/******************************************************************************
 * %Id: isc_api_data.h,v 1.5 2008/12/10 04:36:56 taiyo Exp $
 *
 * FileName		:isc_api_data.h
 *
 * Description	:Definition header of data used on Linux side API
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_ISC_API_DATA_H_
#define	_ISC_API_DATA_H_

#include <linux/iosc/sem_dev.h>

/********************************
*       Macro Definition(s)     *
********************************/
/*
 * i2c bus controller device number
 */
enum {
	ISC_num0,	/* I2C 1st */
	ISC_num1,	/* I2C 2nd */
	ISC_num2,	/* I2C 3rd */
	ISC_num3,	/* I2C 4th */
	ISC_num4,	/* I2C 4th */
	ISC_DEVICE_MAX,    /* Max device number */
};

/*
 * Response code
 */
enum {
	E_ISC_STATUS = 0,			/* Status code of ISC	*/
	E_ISC_BUSY = (E_ISC_STATUS - 1),	/* Bus is already used	*/
	E_ISC_NOACK = (E_ISC_STATUS - 2),	/* No acknowledge	*/
	E_ISC_BUSERR = (E_ISC_STATUS - 3),	/* Bus error		*/
	E_ISC_ERROR = (E_ISC_STATUS - 4),	/* Other errors		*/
};

/*
 * Stop condition definition
 */
enum {
	ISC_NO_STOP,	/* No STOP condition		*/
	ISC_STOP,		/* STOP condition will be done	*/
};

#endif	/* _ISC_API_DATA_H_ */

/* end of isc_api_data.h */
